#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#%%
import numpy as np
import matplotlib.pyplot as plt
# le début du script est le même que précédemment
#%%
d=np.array([0,1.8,3.1,4.1,4.8,5.4,6,6.4,6.8,7.1])
t=0.05*np.arange(10)
#%%
plt.plot(t,d,'bo-',label='distance')
plt.grid()
plt.xlabel("temps")
plt.ylabel("distance")
plt.title("Distance parcourue par le volant en fonction du temps")
plt.show()
#%%
vl=[]
m=np.arange(len(t)-2)
for i in m :
    v=(d[i+2]-d[i])/(t[i+2]-t[i])
    vl.append(v)

al=[]
m=np.arange(len(t)-4)
for i in m :
    a=(vl[i+2]-vl[i])/(t[i+2]-t[i])
    al.append(a)

#%%
v0=vl[1:-1] #on enlève le premier et le dernier termes. 
v1=np.array(v0)
mod=np.polyfit(v1,al,1)
model=mod[0]*v1+mod[1]
print(mod)
plt.plot(v1,al,'ro',label="points expérimentaux")
plt.legend()
plt.plot(v1,model,'b-',label="modèle linéaire")
plt.legend()
plt.grid()
plt.xlabel("vitesse")
plt.ylabel("accélération")
plt.title("Modèle de la force subie par le volant")
plt.show()
#%%
v0=vl[1:-1]
v1=np.array(v0)**2
mod2=np.polyfit(v1,al,1)
model2=mod2[0]*v1+mod2[1]
print(mod2)
plt.plot(v1,al,'ro',label="points expérimentaux")
plt.legend()
plt.plot(v1,model2,'g-',label="modèle quadratique")
plt.legend()
plt.grid()
plt.xlabel("vitesse au carré")
plt.ylabel("accélération")
plt.title("Modèle de la force subie par le volant")
plt.show()
#%%
vll=np.array(vl)
ec=0.0025*vll**2
d2=d[1:-1] # on enlève le premier et le dernier termes. 
ep=0.005*9.8*d2*np.sqrt(2)/2 #ici, le facteur sqrt(2)/2 provient de la projection de la trajectoire sur l'axe vertical : 
# pendant la première phase du mouvement, la direction reste constante (la gravité ne joue pratiquement pas) et l'angle 
#de la trajectoire avec la verticale (pi/4) ne change pas. L'altitude z est donc d.sqrt(2)/2 où d est la distance parcourue
# depuis l'origine
em=ec+ep
t2=0.05*np.arange(8)

plt.plot(t2,ec,'bo-',lw=1,label='Ec')
plt.legend()
plt.plot(t2,ep,'go-',lw=1,label='Ep')
plt.legend()
plt.plot(t2,em,'ro-',lw=1,label='Em')
plt.legend()
plt.grid()
plt.xlabel("temps")
plt.ylabel("énergies")
plt.title("Evolution des diverses énergies pendant le mouvement du volant")
plt.show()
#%%
    